/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.update;

import com.floragunn.searchguard.authtoken.AuthToken;
import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PushAuthTokenUpdateRequest
extends BaseNodesRequest<PushAuthTokenUpdateRequest> {
    private AuthToken updatedToken;
    private UpdateType updateType;
    private long newHash;

    public PushAuthTokenUpdateRequest(StreamInput in) throws IOException {
        super(in);
        this.updatedToken = new AuthToken(in);
        this.updateType = (UpdateType)in.readEnum(UpdateType.class);
        this.newHash = in.readLong();
    }

    public PushAuthTokenUpdateRequest(AuthToken updatedToken, UpdateType updateType, long newHash) {
        super(new String[0]);
        this.updatedToken = updatedToken;
        this.updateType = updateType;
        this.newHash = newHash;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.updatedToken.writeTo(out);
        out.writeEnum((Enum)this.updateType);
        out.writeLong(this.newHash);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public AuthToken getUpdatedToken() {
        return this.updatedToken;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public String toString() {
        return "PushAuthTokenUpdateRequest [updatedToken=" + this.updatedToken + ", updateType=" + (Object)((Object)this.updateType) + "]";
    }

    public long getNewHash() {
        return this.newHash;
    }

    public static enum UpdateType {
        NEW,
        REVOKED;

    }
}

